/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ActualValueSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel fLblBlocks;
    private JComboBox fCmbBlocks;
    private JLabel fLblParamItems;
    private JComboBox fCmbParamItems;
    private WiringDiagram fWD;

    public ActualValueSelectionPanel(WiringDiagram wd) {
        super(new GridBagLayout());
        this.fWD = wd;
        this.init();
    }

    public void setParameterItem(ParameterItem paramItem) throws ProgramException {
        if (null == paramItem) {
            this.fCmbBlocks.setSelectedIndex(-1);
        } else {
            this.fCmbBlocks.setSelectedItem(paramItem.getParameter().getBlock());
            this.fCmbParamItems.setSelectedItem(paramItem);
        }
    }

    public ParameterItem getParameterItem() {
        return (ParameterItem)this.fCmbParamItems.getSelectedItem();
    }

    private void init() {
        this.fLblBlocks = new JLabel(Language.getString("dialog.parameter.message.setBarBlock1", "Block"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.fLblBlocks, gbc);
        this.fCmbBlocks = new JComboBox(this.getBlockListForBarGraph());
        BlockListCellRenderer renderer = new BlockListCellRenderer(true);
        renderer.setScale(0.7f);
        this.fCmbBlocks.setRenderer(renderer);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.fCmbBlocks, gbc);
        this.fLblParamItems = new JLabel(Language.getString("dialog.parameter.message.setBarBlock", "Actual value:"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.fLblParamItems, gbc);
        this.fCmbParamItems = new JComboBox();
        BarGraphParamListCellRenderer paramRenderer = new BarGraphParamListCellRenderer();
        this.fCmbParamItems.setRenderer(paramRenderer);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.fCmbParamItems, gbc);
        this.fCmbBlocks.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ActualValueSelectionPanel.this.fillParameterList();
            }
        });
        this.fillParameterList();
    }

    private Vector getBlockListForBarGraph() {
        Vector<Block> blocks = new Vector<Block>();
        Enumeration blockEnum = this.fWD.getBlocks().elements();
        while (blockEnum.hasMoreElements()) {
            Block block = (Block)blockEnum.nextElement();
            if (!this.isContainsActualValueForBarGraph(block)) continue;
            blocks.addElement(block);
        }
        return blocks;
    }

    public boolean isAvailable() {
        return this.fCmbBlocks.getItemCount() > 0;
    }

    private boolean isContainsActualValueForBarGraph(Block block) {
        return this.getBarGraphParamItems(block).size() > 0;
    }

    private void fillParameterList() {
        Block block = (Block)this.fCmbBlocks.getSelectedItem();
        this.fCmbParamItems.setModel(new DefaultComboBoxModel(this.getBarGraphParamItems(block)));
    }

    private Vector getBarGraphParamItems(Block block) {
        Vector<ParameterItem> ret = new Vector<ParameterItem>();
        if (block == null || block.getParameter() == null) {
            return ret;
        }
        BlockParameter blockParameter = block.getParameter();
        for (ParameterItem parameterItem : blockParameter.getParameterItems().getPublicParameterItemList()) {
            ParameterItem inst = parameterItem.getInstanceForParameter(block.getParameter());
            if (!this.isSupportParamItemType(inst)) continue;
            ret.add(inst);
        }
        return ret;
    }

    private boolean isSupportParamItemType(ParameterItem paramItem) {
        if (paramItem.getParameterValueType() != 1) {
            return false;
        }
        Object value = paramItem.getValue();
        return value instanceof IntValueProperties || value instanceof IntegerOrBlockReference || value instanceof Integer || value instanceof Long;
    }

    public static class BarGraphParamListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ParameterItem) {
                ParameterItem parameterItem = (ParameterItem)value;
                this.setText(parameterItem.getLocalisedName());
                Icon icon = null;
                this.setIcon(icon);
            }
            return this;
        }
    }
}

